﻿/* 

ATTENTION : remplacer "sicen" par le nom de la base postgis préalablement créée avant d'exécuter

exemple : CREATE DATABASE sicen WITH TEMPLATE=template_postgis_20;

Remarque : connectez-vous à la base avant de lancer ce script

*/

--
-- Rôles et groupes de connexion
--

CREATE ROLE sicen_cnx;
ALTER ROLE sicen_cnx WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN PASSWORD 'sicen_cnx';
CREATE ROLE sicen_amateur;
ALTER ROLE sicen_amateur WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN PASSWORD 'sicen_amateur';
CREATE ROLE sicen_expert;
ALTER ROLE sicen_expert WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN PASSWORD 'sicen_expert';
CREATE ROLE sicen_admin;
ALTER ROLE sicen_admin WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB LOGIN PASSWORD 'sicen_admin';

CREATE ROLE sicen_gr_observ;
ALTER ROLE sicen_gr_observ WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN;
CREATE ROLE sicen_gr_consult;
ALTER ROLE sicen_gr_consult WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN ;
CREATE ROLE sicen_gr_amateur;
ALTER ROLE sicen_gr_amateur WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN ;
CREATE ROLE sicen_gr_expert;
ALTER ROLE sicen_gr_expert WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN ;
CREATE ROLE sicen_gr_admin;
ALTER ROLE sicen_gr_admin WITH NOSUPERUSER INHERIT NOCREATEROLE NOCREATEDB NOLOGIN;

GRANT sicen_gr_observ TO sicen_gr_consult;
GRANT sicen_gr_consult TO sicen_gr_amateur;
GRANT sicen_gr_amateur TO sicen_gr_expert;
GRANT sicen_gr_expert TO sicen_gr_admin;

GRANT sicen_gr_amateur TO sicen_amateur;
GRANT sicen_gr_admin TO sicen_admin;
GRANT sicen_gr_expert TO sicen_expert;

--
-- Droits d'accès principaux
--

GRANT CONNECT ON DATABASE sicen TO sicen_gr_consult;
GRANT TEMPORARY ON DATABASE sicen TO sicen_gr_amateur;
GRANT CONNECT, TEMPORARY ON DATABASE sicen TO sicen_cnx;

GRANT SELECT ON TABLE spatial_ref_sys TO sicen_gr_consult;

--
-- PostgreSQL database dump
--

-- Dumped from database version 9.0.7
-- Dumped by pg_dump version 9.0.7
-- Started on 2012-12-26 10:29:58

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 8 (class 2615 OID 90341)
-- Name: ign_bd_topo; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA ign_bd_topo;


--
-- TOC entry 3158 (class 0 OID 0)
-- Dependencies: 8
-- Name: SCHEMA ign_bd_topo; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA ign_bd_topo IS 'Ce schéma contient initialement les tables de la BD TOPO.
Pour pouvoir utiliser l''application, il faut intégrer les données communales, avec composante spatiale à la table "commune".';


--
-- TOC entry 9 (class 2615 OID 90342)
-- Name: inpn; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA inpn;


--
-- TOC entry 3160 (class 0 OID 0)
-- Dependencies: 9
-- Name: SCHEMA inpn; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA inpn IS 'Ce schéma contient les référentiels mis à disposition part l''INPN.
Ils ont été intégrés selon la méthde décrite ici : http://sig.cenlr.org/integration_donnees/externes/inpn .';


--
-- TOC entry 10 (class 2615 OID 90343)
-- Name: md; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA md;


--
-- TOC entry 3162 (class 0 OID 0)
-- Dependencies: 10
-- Name: SCHEMA md; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA md IS 'Schéma permettant la gestion des métadonnées : personnes, structures, protocoles, études, sites lots de donnees.';


--
-- TOC entry 11 (class 2615 OID 90344)
-- Name: outils; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA outils;


--
-- TOC entry 12 (class 2615 OID 90345)
-- Name: saisie; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA saisie;


--
-- TOC entry 3165 (class 0 OID 0)
-- Dependencies: 12
-- Name: SCHEMA saisie; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA saisie IS 'Schéma de saisie des données : observations occasionelles naturalistes.';


SET search_path = md, public, pg_catalog;

--
-- TOC entry 1547 (class 1247 OID 90347)
-- Dependencies: 10
-- Name: enum_role; Type: TYPE; Schema: md; Owner: -
--

CREATE TYPE enum_role AS ENUM (
    'observ',
    'consult',
    'amateur',
    'expert',
    'admin'
);


--
-- TOC entry 1550 (class 1247 OID 90354)
-- Dependencies: 10
-- Name: enum_specialite; Type: TYPE; Schema: md; Owner: -
--

CREATE TYPE enum_specialite AS ENUM (
    'faune',
    'flore',
    'habitat',
    'fonge'
);


--
-- TOC entry 1553 (class 1247 OID 90359)
-- Dependencies: 10
-- Name: enum_titre; Type: TYPE; Schema: md; Owner: -
--

CREATE TYPE enum_titre AS ENUM (
    'Mme',
    'Melle',
    'M.'
);


SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 1613 (class 1247 OID 92214)
-- Dependencies: 12
-- Name: enum_age; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_age AS ENUM (
    'Oeuf/ponte',
    'Juvénile',
    'Adulte',
    'Indéterminé'
);


--
-- TOC entry 1631 (class 1247 OID 93384)
-- Dependencies: 12
-- Name: enum_determination; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_determination AS ENUM (
    'Vu',
    'Entendu',
    'Indice de présence',
    'Cadavre',
    'Capture'
);


--
-- TOC entry 1607 (class 1247 OID 92203)
-- Dependencies: 12
-- Name: enum_etat_de_conservation; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_etat_de_conservation AS ENUM (
    'Bon',
    'Moyen',
    'Mauvais'
);


--
-- TOC entry 1604 (class 1247 OID 92198)
-- Dependencies: 12
-- Name: enum_phenologie; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_phenologie AS ENUM (
    'Plantule',
    'Juvénille',
    'Adulte'
);


--
-- TOC entry 1556 (class 1247 OID 90380)
-- Dependencies: 12
-- Name: enum_precision; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_precision AS ENUM (
    'GPS',
    '0 à 10m',
    '10 à 100m',
    '100 à 500m',
    'lieu-dit',
    'commune'
);


--
-- TOC entry 1601 (class 1247 OID 92193)
-- Dependencies: 12
-- Name: enum_sexe; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_sexe AS ENUM (
    'Mâle',
    'Femelle',
    'Indéterminé'
);


--
-- TOC entry 1622 (class 1247 OID 129660)
-- Dependencies: 12
-- Name: enum_stade_phenologique; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_stade_phenologique AS ENUM (
    ''
);


--
-- TOC entry 1619 (class 1247 OID 129656)
-- Dependencies: 12
-- Name: enum_stade_reproductif; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_stade_reproductif AS ENUM (
    'Multiplication végétative',
    'Reproduction sexuée'
);


--
-- TOC entry 1559 (class 1247 OID 90388)
-- Dependencies: 12
-- Name: enum_statut_validation; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_statut_validation AS ENUM (
    'validée',
    'à valider',
    'non valide'
);


--
-- TOC entry 1616 (class 1247 OID 92220)
-- Dependencies: 12
-- Name: enum_type_effectif; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_type_effectif AS ENUM (
    ''
);


--
-- TOC entry 1610 (class 1247 OID 92208)
-- Dependencies: 12
-- Name: enum_unite; Type: TYPE; Schema: saisie; Owner: -
--

CREATE TYPE enum_unite AS ENUM (
    'Simple',
    'Mosaïque spatiale',
    'Mosaïque temporelle',
    'Mosaïque mixte'
);


SET search_path = md, public, pg_catalog;


--

-- TOC entry 1193 (class 1255 OID 90393)
-- Dependencies: 1634 10
-- Name: liste_nom_auteur(text); Type: FUNCTION; Schema: md; Owner: -
--

CREATE FUNCTION liste_nom_auteur(text) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
    var_liste_code_personne ALIAS for $1;
BEGIN
RETURN string_agg(nom || ' ' || prenom,' & ') FROM (SELECT regexp_split_to_table(var_liste_code_personne,'&')::integer as id_personne) t
LEFT JOIN md.personne USING(id_personne);
END;
$_$;


--
-- TOC entry 1194 (class 1255 OID 90394)
-- Dependencies: 1634 10
-- Name: liste_nom_structure(text); Type: FUNCTION; Schema: md; Owner: -
--

CREATE FUNCTION liste_nom_structure(text) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
    var_liste_code_structure ALIAS for $1;
BEGIN
RETURN string_agg(nom_structure,' & ') FROM (SELECT regexp_split_to_table(var_liste_code_structure,'&')::integer as id_structure) t
LEFT JOIN md.structure USING(id_structure);
END;
$_$;


SET search_path = outils, public, pg_catalog;

--
-- TOC entry 1196 (class 1255 OID 135377)
-- Dependencies: 11 1634
-- Name: enum_add(character varying, character varying, character varying); Type: FUNCTION; Schema: outils; Owner: -
--

CREATE FUNCTION enum_add(enum_name character varying, enum_elem character varying, enum_schema character varying DEFAULT 'public'::character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
DECLARE
    schemaoid       integer;
BEGIN
    SELECT oid INTO schemaoid FROM pg_namespace WHERE nspname = enum_schema;
    IF NOT FOUND THEN
    RAISE EXCEPTION ''Could not find schema ''''%'''''', enum_schema;
    END IF;
    INSERT INTO pg_enum(enumtypid, enumlabel) VALUES(
        (SELECT oid FROM pg_type WHERE typtype=''e'' AND typname=enum_name AND typnamespace = schemaoid),
        enum_elem
    );
END;
';


--
-- TOC entry 1197 (class 1255 OID 135378)
-- Dependencies: 11 1634
-- Name: enum_del(character varying, character varying, character varying); Type: FUNCTION; Schema: outils; Owner: -
--

CREATE FUNCTION enum_del(enum_name character varying, enum_elem character varying, enum_schema character varying DEFAULT 'public'::character varying) RETURNS void
    LANGUAGE plpgsql
    AS '
DECLARE
    type_oid INTEGER;
    rec RECORD;
    sql VARCHAR;
    ret INTEGER;
    schemaoid INTEGER;
BEGIN
    SELECT oid INTO schemaoid FROM pg_namespace WHERE nspname = enum_schema;
    IF NOT FOUND THEN
    RAISE EXCEPTION ''Could not find schema ''''%'''''', enum_schema;
    END IF;
    SELECT pg_type.oid
    FROM pg_type
    WHERE typtype = ''e'' AND typname = enum_name AND typnamespace = schemaoid
    INTO type_oid;
    IF NOT FOUND THEN
        RAISE EXCEPTION ''Cannot find a enum: %'', enum_name;
    END IF;
    -- Check column DEFAULT value references.
    SELECT *
    FROM
        pg_attrdef
        JOIN pg_attribute ON attnum = adnum AND atttypid = type_oid
        JOIN pg_class ON pg_class.oid = attrelid
        JOIN pg_namespace ON pg_namespace.oid = relnamespace
    WHERE
        adsrc = quote_literal(enum_elem) || ''::'' || quote_ident(enum_name)
    LIMIT 1
    INTO rec;
    IF FOUND THEN
        RAISE EXCEPTION
            ''Cannot delete the ENUM element %.%: column %.%.% has DEFAULT value of ''''%'''''',
            quote_ident(enum_name), quote_ident(enum_elem),
            quote_ident(rec.nspname), quote_ident(rec.relname),
            rec.attname, quote_ident(enum_elem);
    END IF;
    -- Check data references.
    FOR rec IN
        SELECT *
        FROM
            pg_attribute
            JOIN pg_class ON pg_class.oid = attrelid
            JOIN pg_namespace ON pg_namespace.oid = relnamespace
        WHERE
            atttypid = type_oid
            AND relkind = ''r''
    LOOP
        sql :=
            ''SELECT 1 FROM ONLY ''
            || quote_ident(rec.nspname) || ''.''
            || quote_ident(rec.relname) || '' ''
            || '' WHERE ''
            || quote_ident(rec.attname) || '' = ''
            || quote_literal(enum_elem)
            || '' LIMIT 1'';
        EXECUTE sql INTO ret;
        IF ret IS NOT NULL THEN
            RAISE EXCEPTION
                ''Cannot delete the ENUM element %.%: column %.%.% contains references'',
                quote_ident(enum_name), quote_ident(enum_elem),
                quote_ident(rec.nspname), quote_ident(rec.relname),
                rec.attname;
        END IF;
    END LOOP;
    -- OK. We may delete.
    DELETE FROM pg_enum WHERE enumtypid = type_oid AND enumlabel = enum_elem;
END;
';


--
-- TOC entry 1198 (class 1255 OID 90395)
-- Dependencies: 1634 11
-- Name: get_user(); Type: FUNCTION; Schema: outils; Owner: -
--

CREATE FUNCTION get_user() RETURNS text
    LANGUAGE plpgsql STABLE
    AS '
declare
ergebnis text;
    BEGIN
        perform relname from pg_class
            where relname = ''icke_tmp''
              and case when has_schema_privilege(relnamespace, ''USAGE'')
                    then pg_table_is_visible(oid) else false end;
  if not found then
    return ''inconnu'';
  else
    select id_user from icke_tmp into ergebnis;
  end if;
  if not found then
    ergebnis:=''inconnu'';
  end if;
  RETURN ergebnis;
  END;
 ';


--
-- TOC entry 1199 (class 1255 OID 90396)
-- Dependencies: 1634 11
-- Name: set_user(text); Type: FUNCTION; Schema: outils; Owner: -
--

CREATE FUNCTION set_user(myid_user text) RETURNS integer
    LANGUAGE plpgsql
    AS '
    BEGIN
        perform relname from pg_class
            where relname = ''icke_tmp''
              and case when has_schema_privilege(relnamespace, ''USAGE'')
                    then pg_table_is_visible(oid) else false end;
        if not found then
            create temporary table icke_tmp (
                id_user text
            );
        else
           delete from icke_tmp;
        end if;

        insert into icke_tmp values (myid_user);
  RETURN 0;
  END;
 ';



SET search_path = saisie, public, pg_catalog;

--

-- TOC entry 1195 (class 1255 OID 90397)
-- Dependencies: 12 1634
-- Name: alimente_suivi_saisie_observation(); Type: FUNCTION; Schema: saisie; Owner: -
--

CREATE FUNCTION alimente_suivi_saisie_observation() RETURNS trigger
    LANGUAGE plpgsql
    AS ' declare
user_login text; BEGIN 
user_login = outils.get_user();
IF (TG_OP = ''DELETE'') THEN INSERT INTO saisie.suivi_saisie_observation SELECT ''DELETE'', now(), user_login, OLD.*; RETURN OLD; ELSIF (TG_OP = ''UPDATE'') THEN INSERT INTO saisie.suivi_saisie_observation SELECT ''UPDATE'', now(), user_login, NEW.*; RETURN NEW; ELSIF (TG_OP = ''INSERT'') THEN INSERT INTO saisie.suivi_saisie_observation SELECT ''INSERT'', now(), user_login, NEW.*; RETURN NEW; END IF; RETURN NULL; END; ';


SET search_path = ign_bd_topo, public, pg_catalog;

SET default_with_oids = false;

--
-- TOC entry 207 (class 1259 OID 107876)
-- Dependencies: 3079 3080 3081 1489 8
-- Name: commune; Type: TABLE; Schema: ign_bd_topo; Owner: -
--

CREATE TABLE commune (
    nom text,
    code_insee text NOT NULL,
    depart text--,
    --geometrie geometry(MULTIPOLYGON,2154)
);


--
-- TOC entry 206 (class 1259 OID 106857)
-- Dependencies: 3076 3077 3078 8 1489
-- Name: lieu_dit; Type: TABLE; Schema: ign_bd_topo; Owner: -
--

CREATE TABLE lieu_dit (
    id text NOT NULL,
    nom text--,
    --geometrie geometry(POINT,2154)
);


SET search_path = inpn, public, pg_catalog;

--
-- TOC entry 208 (class 1259 OID 116733)
-- Dependencies: 9
-- Name: taxref; Type: TABLE; Schema: inpn; Owner: -
--

CREATE TABLE taxref (
    regne text,
    phylum text,
    classe text,
    ordre text,
    famille text,
    cd_nom text NOT NULL,
    cd_ref text,
    nom_complet text,
    nom_valide text,
    nom_vern text,
	lb_nom text
);


--
-- TOC entry 3171 (class 0 OID 0)
-- Dependencies: 208
-- Name: TABLE taxref; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON TABLE taxref IS 'Table issue du site de l''INPN.

Les genres ont été créés. Attention lors des mises à jour de référentiel.
Attention aussi aux espaces en début de chaine.
';


--
-- TOC entry 3172 (class 0 OID 0)
-- Dependencies: 208
-- Name: COLUMN taxref.regne; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON COLUMN taxref.regne IS 'nom scientifique du règne du taxon';


--
-- TOC entry 3173 (class 0 OID 0)
-- Dependencies: 208
-- Name: COLUMN taxref.cd_nom; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON COLUMN taxref.cd_nom IS 'identifiant unique';


--
-- TOC entry 3174 (class 0 OID 0)
-- Dependencies: 208

-- Name: COLUMN taxref.cd_ref; Type: COMMENT; Schema: inpn; Owner: -
--


COMMENT ON COLUMN taxref.cd_ref IS 'renvoi au cd_nom du taxon de référence';


--
-- TOC entry 3175 (class 0 OID 0)
-- Dependencies: 208

-- Name: COLUMN taxref.nom_complet; Type: COMMENT; Schema: inpn; Owner: -
--


COMMENT ON COLUMN taxref.nom_complet IS 'nom scientifique complet du taxon (généralement lb_nom + lb_auteur)';


--
-- TOC entry 3176 (class 0 OID 0)
-- Dependencies: 208
-- Name: COLUMN taxref.nom_vern; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON COLUMN taxref.nom_vern IS 'nom vernaculaire du taxon en français';


--
-- TOC entry 209 (class 1259 OID 128802)
-- Dependencies: 9
-- Name: typo_corine_biotopes; Type: TABLE; Schema: inpn; Owner: -
--

CREATE TABLE typo_corine_biotopes (
    cd_cb text NOT NULL,
    lb_cb97_fr text
);


--
-- TOC entry 3178 (class 0 OID 0)
-- Dependencies: 209
-- Name: TABLE typo_corine_biotopes; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON TABLE typo_corine_biotopes IS 'Table : TYPO_CORINE_BIOTOPES
Nom du jeu de données : Typologie CORINE Biotopes
Date de création de la table : 09/07/2009
Date de dernière mise à jour de la table : 12/02/2010
Date de dernière mise à jour de la métadonnée : 08/04/2010
Auteur de la typologie : Pierre DEVILLERS, Jean DEVILLERS-TERSCHUREN et Jean-Paul LEDANT (Institut Royal des Sciences Naturelles, Bruxelles) pour la version originale de 1991. Myriam BISSARDON et Lucas GUIBAL (École nationale du génie rural, des eaux et des forêts, Nancy / ENGREF) pour la traduction française de 1997.
Auteur de la table : Vincent GAUDILLAT (Service du patrimoine naturel - Muséum national d''histoire naturelle / SPN-MNHN)
Territoire concerné : Europe de l''Ouest (Europe des 12 de l''époque : Allemagne, Belgique, Danemark, Espagne, France, Grande-Bretagne, Grèce, Irlande, Italie, Luxembourg, Pays-Bas, Portugal)
Organisme responsable : Commission européenne
Langue des données : UK, FR
Présentation / Contexte : La typologie CORINE Biotopes est un système hiérarchisé de classification des habitats européens élaboré dans le cadre du programme CORINE (Coordination of Information on the Environment). L''objectif était d''identifier et de décrire les biotopes d''importance majeure pour la conservation de la nature au sein de la Communauté européenne. Cette typologie parue en 1991 (Devillers et al.) comporte 2584 codes répartis en 7 grandes familles de milieux (1. Coastal and halophytic communities, 2. Non-marine waters, 3. Scrub and grassland, 4. Forests, 5. Bogs and marshes, 6. Inland rocks, screes and sands, 8. Agricultural land and artificial landscapes). Les habitats naturels et semi-naturels sont plus ou moins détaillés selon les cas avec une précision accrue pour certains types de végétations considérés comme ayant un fort intérêt patrimonial en Europe, les autres habitats sont traités plus sommairement. La typologie s''appuie largement sur la classification phytosociologique - avec laquelle elle propose des correspondances indicatives -, mais intègre également d''autres paramètres comme la dominance physionomique d''une espèce ou une localisation géographique donnée. Les codes à un chiffre correspondent aux grandes familles de milieux citées précédemment, on ajoute ensuite un autre chiffre puis une décimale et jusqu''à 6 chiffres après la décimale pour décrire des types de végétation de plus en plus précis. Cette typologie n''ayant fait l''objet d''aucune édition française, une traduction non officielle en français d''une partie de la typologie a été réalisée par l''ENGREF en 1997 (Bissardon et Guibal). Elle suit le texte original sans ajout de texte (mis à part 2 nouveaux codes par rapport à la version de 1991) mais seuls ont été repris les codes qui selon les auteurs concernaient la France. Il est à noter que les champs correspondants n''ont pas toujours été traduits dans leur intégralité. Cette version comporte 1478 codes (dont les 2 nouveaux codes précédemment évoqués). 
Description du travail : Mise en table de la typologie CORINE Biotopes avec mise en parallèle de la version originale de 1991 avec la version en français de 1997. Quelques petites corrections (essentiellement orthographiques ou typographiques) ont été apportées à l''occasion de la mise en table des textes. La création d''un champ "France" permet de filtrer les codes présents dans notre pays, il s''agit des codes de la version en français de 1997 auxquels quelques codes supplémentaires qui n''avaient pas été retenus dans celle-ci ont été ajoutés. Les intitulés et descriptifs de ces derniers ont été traduits dans leur intégralité (sauf précision contraire, ces traductions ont été effectuées par le SPN). Exceptionnellement, quelques codes cités dans la version en français ont été retirés car considérés comme absents en France.
Origine du jeu de données : Version originale en anglais (Devillers et al., 1991) : fichier Word envoyé par Dorian MOSS le 9/11/2007 ("CORINE HABITATS 1991.rtf"). Ce fichier comporte de légères différences avec la version éditée papier ; il s''agit généralement de différences typographiques, ponctuellement du remplacement d''un mot par un autre.  - Version en français (Bissardon et Guibal, 1997) : fichier Word envoyé par Jean-Claude RAMEAU (ENGREF) ("corin97.doc") correspondant au texte de la version éditée papier.
Références bibliographiques : DEVILLERS P., DEVILLERS-TERSCHUREN J., LEDANT J.-P. & coll., 1991. CORINE biotopes manual. Habitats of the European Community. Data specifications - Part 2. EUR 12587/3 EN. European Commission, Luxembourg, 300 p. [ISBN 92-826-3211-3] BISSARDON M. et GUIBAL L., 1997. Corine biotopes. Version originale. Types d''habitats français. ENGREF, Nancy, 217 p.
Mots clés : Typologie, habitats, Corine Biotopes, classification européenne.
Référencement à utiliser : DEVILLERS P., DEVILLERS-TERSCHUREN J., LEDANT J.-P. & coll., 1991. CORINE biotopes manual. Habitats of the European Community. Data specifications - Part 2. EUR 12587/3 EN. European Commission, Luxembourg, 300 p. Traduction pour les types d''habitats présents en France : BISSARDON M. et GUIBAL L., 1997. Corine biotopes. Version originale. Types d''habitats français. ENGREF, Nancy, 217 p. Mise en table : SPN-MNHN / INPN, février 2010.';


--
-- TOC entry 3179 (class 0 OID 0)
-- Dependencies: 209
-- Name: COLUMN typo_corine_biotopes.cd_cb; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON COLUMN typo_corine_biotopes.cd_cb IS 'Code CORINE Biotopes, à 1 ou 2 chiffres suivis au maximum de 6 décimales. Dans le fichier Word de la version de 1991, le code 22.5 de la version papier est absent et on remarque le codage en 41.F3 de l habitat 41.F13 de la version papier (qui lui ne figure pas dans le fichier). Ces deux éléments ont été corrigés dans la présente table de manière à respecter la version papier, soit ajout du 22.5 et correction du 41.F3 en 41.F13. 2 codes apparaissant dans la version de 1997 n existent pas dans la version originale anglaise : 15.811 (Steppes à Lavande de mer ibériques) et 15.8114 (Steppes à Lavande de mer catalano-provençales). Ils ont néanmoins été ajoutés à la table générale, mais sans intitulé ou descriptif en anglais. Au chapitre 86 de la version de 1997 (papier et fichier original) les codes 86.411 à 86.6 ont été notés par erreur 84.411 à 84.6 ; ces codes ont été corrigés dans la présente base.;';


--
-- TOC entry 3180 (class 0 OID 0)
-- Dependencies: 209
-- Name: COLUMN typo_corine_biotopes.lb_cb97_fr; Type: COMMENT; Schema: inpn; Owner: -
--

COMMENT ON COLUMN typo_corine_biotopes.lb_cb97_fr IS 'Intitulé de l''habitat selon la version en français de 1997 ou traduction nouvelle dans le cas de codes non retenus dans cette version mais présents en France.';











SET search_path = md, public, pg_catalog;

--
-- TOC entry 195 (class 1259 OID 90422)
-- Dependencies: 10
-- Name: etude_id_etude_seq; Type: SEQUENCE; Schema: md; Owner: -
--

CREATE SEQUENCE etude_id_etude_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 196 (class 1259 OID 90424)
-- Dependencies: 3063 10
-- Name: etude; Type: TABLE; Schema: md; Owner: -
--

CREATE TABLE etude (
    id_etude integer DEFAULT nextval('etude_id_etude_seq'::regclass) NOT NULL,
    nom_etude text,
    cahier_des_charges text,
    date_debut date,
    date_fin date,
    description text,
    lien_rapport_final text
);


--
-- TOC entry 3183 (class 0 OID 0)
-- Dependencies: 196
-- Name: TABLE etude; Type: COMMENT; Schema: md; Owner: -
--

COMMENT ON TABLE etude IS 'Cette table est nécessaire pour associer les données produites ou stockées dans la bdd aux études qui les ont mobilisé ou qui ont nécessité leur production. C''est un élément important de description de la donnée.';


--
-- TOC entry 197 (class 1259 OID 90431)
-- Dependencies: 3064 1547 10 1550 1553
-- Name: personne; Type: TABLE; Schema: md; Owner: -
--

CREATE TABLE personne (
	id_personne integer NOT NULL,
	remarque text,
	fax text,
	portable text,
	tel_pro text,
	tel_perso text,
	pays text,
	ville text,
	code_postal text,
	adresse_1 text,
	prenom text NOT NULL,
	nom text NOT NULL,
	email text,
	role md.enum_role,
	specialite md.enum_specialite,
	mot_de_passe text NOT NULL DEFAULT 0,
	createur integer,
	titre md.enum_titre,
	date_maj date
);


--
-- TOC entry 3185 (class 0 OID 0)
-- Dependencies: 197
-- Name: TABLE personne; Type: COMMENT; Schema: md; Owner: -
--

COMMENT ON TABLE personne IS 'Contient les informations relatives aux personnes ayant par exemple fourni des données au CEN LR ou ayant produit des données dans le cadre d''activité salariée ou de stage.';


--
-- TOC entry 198 (class 1259 OID 90438)
-- Dependencies: 10 197
-- Name: personne_id_personne_seq; Type: SEQUENCE; Schema: md; Owner: -
--

CREATE SEQUENCE personne_id_personne_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3187 (class 0 OID 0)
-- Dependencies: 198
-- Name: personne_id_personne_seq; Type: SEQUENCE OWNED BY; Schema: md; Owner: -
--

ALTER SEQUENCE personne_id_personne_seq OWNED BY personne.id_personne;


--
-- TOC entry 199 (class 1259 OID 90440)
-- Dependencies: 10
-- Name: protocole; Type: TABLE; Schema: md; Owner: -
--

CREATE TABLE protocole (
    id_protocole integer NOT NULL,
    libelle text,
    resume text
);


--
-- TOC entry 3189 (class 0 OID 0)
-- Dependencies: 199
-- Name: TABLE protocole; Type: COMMENT; Schema: md; Owner: -
--

COMMENT ON TABLE protocole IS 'Liste les protocoles utilisés pour la récolte des donéees stockées dans le système d''information.';


--
-- TOC entry 200 (class 1259 OID 90446)
-- Dependencies: 10 199
-- Name: protocole_id_protocole_seq; Type: SEQUENCE; Schema: md; Owner: -
--

CREATE SEQUENCE protocole_id_protocole_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3191 (class 0 OID 0)
-- Dependencies: 200
-- Name: protocole_id_protocole_seq; Type: SEQUENCE OWNED BY; Schema: md; Owner: -
--

ALTER SEQUENCE protocole_id_protocole_seq OWNED BY protocole.id_protocole;


--
-- TOC entry 201 (class 1259 OID 90448)
-- Dependencies: 3067 10
-- Name: structure; Type: TABLE; Schema: md; Owner: -
--

CREATE TABLE structure (
    id_structure integer NOT NULL,
    nom_structure text,
    detail_nom_structure text,
    statut text,
    adresse_1 text,
    code_postal text,
    ville text,
    pays text,
    tel text,
    fax text,
    courriel_1 text,
    courriel_2 text,
    site_web text,
    remarque text,
    createur integer,
    diffusable boolean DEFAULT true,
    date_maj date
);


--
-- TOC entry 3193 (class 0 OID 0)
-- Dependencies: 201
-- Name: TABLE structure; Type: COMMENT; Schema: md; Owner: -
--

COMMENT ON TABLE structure IS 'Stocke les informations sur les structures partenaires du CEN, ou ayant produit des informations stockée ou ayant commandé des études...';


--
-- TOC entry 202 (class 1259 OID 90455)
-- Dependencies: 10 201
-- Name: structure_id_structure_seq; Type: SEQUENCE; Schema: md; Owner: -
--

CREATE SEQUENCE structure_id_structure_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3195 (class 0 OID 0)
-- Dependencies: 202
-- Name: structure_id_structure_seq; Type: SEQUENCE OWNED BY; Schema: md; Owner: -
--

ALTER SEQUENCE structure_id_structure_seq OWNED BY structure.id_structure;



SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 203 (class 1259 OID 90457)

-- Dependencies: 3069 3071 3072 1489 1559 12 1556 1631
-- Name: saisie_observation; Type: TABLE; Schema: saisie; Owner: -
--

CREATE TABLE saisie_observation (
	id_obs integer NOT NULL,
	date_obs date,
	date_debut_obs date,
	date_fin_obs date,
	date_textuelle text,
	regne text,
	nom_vern text,
	nom_complet text,
	cd_nom text,
	effectif_textuel text,
	effectif_min bigint,
	effectif_max bigint,
	type_effectif text,
	phenologie text,
	id_waypoint text,
	longitude double precision,
	latitude double precision,
	localisation text,
	observateur text,
	numerisateur integer,
	validateur integer,
	structure text,
	remarque_obs text,
	code_insee text,
	id_lieu_dit text,
	diffusable boolean DEFAULT true,
	"precision" saisie.enum_precision,
	statut_validation saisie.enum_statut_validation,
	id_etude integer,
	id_protocole integer,
	effectif bigint,
	url_photo text,
	commentaire_photo text,
	decision_validation text,
	heure_obs time without time zone,
	determination saisie.enum_determination,
	elevation bigint--,
	--geometrie geometry(GEOMETRY,2154)
);


--
-- TOC entry 3197 (class 0 OID 0)
-- Dependencies: 203
-- Name: TABLE saisie_observation; Type: COMMENT; Schema: saisie; Owner: -
--

COMMENT ON TABLE saisie_observation IS 'Table intermédaire entre les données extérieures au SI et les tables de la base de données.
Les données contenues dans cette table sont ventilées aprés vérification dans les tables "entite_spatiale_ecologique", "point_faune", "personne_est_auteur_donnee", "structure_est_auteur_donnee" et "structure_a_rendu_ese".
Il manque la référence possible à une photo, un échantillon...
L''attribut id_entite est renseigné automatiquement lors de la ventilation des données.
L''attribut regne permet le filtrage des données.
La saise de l''effectif est libre. Il faudra probablerment la cadre à l''usage.
Un seul validateur est stocké.
Une seule commune et une seule localisation aussi.';


--
-- TOC entry 204 (class 1259 OID 90466)
-- Dependencies: 12 203
-- Name: saisie_observation_id_obs_seq; Type: SEQUENCE; Schema: saisie; Owner: -
--

CREATE SEQUENCE saisie_observation_id_obs_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3202 (class 0 OID 0)
-- Dependencies: 204
-- Name: saisie_observation_id_obs_seq; Type: SEQUENCE OWNED BY; Schema: saisie; Owner: -
--

ALTER SEQUENCE saisie_observation_id_obs_seq OWNED BY saisie_observation.id_obs;


--
-- TOC entry 205 (class 1259 OID 90468)

-- Dependencies: 3073 3074 3075 12 1556 1559 1489 1631
-- Name: suivi_saisie_observation; Type: TABLE; Schema: saisie; Owner: -
--

CREATE TABLE suivi_saisie_observation (
	operation text,
	date_operation timestamp without time zone NOT NULL,
	utilisateur text NOT NULL,
	id_obs integer NOT NULL,
	date_obs date,
	date_debut_obs date,
	date_fin_obs date,
	date_textuelle text,
	regne text,
	nom_vern text,
	nom_complet text,
	cd_nom text,
	effectif_textuel text,
	effectif_min bigint,
	effectif_max bigint,
	type_effectif text,
	phenologie text,
	id_waypoint text,
	longitude double precision,
	latitude double precision,
	localisation text,
	observateur text,
	numerisateur integer,
	validateur integer,
	structure text,
	remarque_obs text,
	code_insee text,
	id_lieu_dit text,
	diffusable boolean DEFAULT true,
	"precision" saisie.enum_precision,
	statut_validation saisie.enum_statut_validation,
	id_etude integer,
	id_protocole integer,
	effectif bigint,
	url_photo text,
	commentaire_photo text,
	decision_validation text,
	heure_obs time without time zone,
	determination saisie.enum_determination,
	elevation bigint--,
	--geometrie geometry(GEOMETRY,2154)
);


--
-- TOC entry 3204 (class 0 OID 0)
-- Dependencies: 205
-- Name: TABLE suivi_saisie_observation; Type: COMMENT; Schema: saisie; Owner: -
--

COMMENT ON TABLE suivi_saisie_observation IS 'Table qui enregistre l''ensemble des actions (type, heure, utilisateur) effectuée sur la table saisie_observation.';


SET search_path = md, public, pg_catalog;

--
-- TOC entry 3065 (class 2604 OID 90477)
-- Dependencies: 198 197
-- Name: id_personne; Type: DEFAULT; Schema: md; Owner: -
--

ALTER TABLE ONLY personne ALTER COLUMN id_personne SET DEFAULT nextval('personne_id_personne_seq'::regclass);


--
-- TOC entry 3066 (class 2604 OID 90478)
-- Dependencies: 200 199
-- Name: id_protocole; Type: DEFAULT; Schema: md; Owner: -
--

ALTER TABLE ONLY protocole ALTER COLUMN id_protocole SET DEFAULT nextval('protocole_id_protocole_seq'::regclass);


--
-- TOC entry 3068 (class 2604 OID 90479)
-- Dependencies: 202 201
-- Name: id_structure; Type: DEFAULT; Schema: md; Owner: -
--

ALTER TABLE ONLY structure ALTER COLUMN id_structure SET DEFAULT nextval('structure_id_structure_seq'::regclass);


SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 3070 (class 2604 OID 90480)
-- Dependencies: 204 203
-- Name: id_obs; Type: DEFAULT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation ALTER COLUMN id_obs SET DEFAULT nextval('saisie_observation_id_obs_seq'::regclass);


SET search_path = ign_bd_topo, public, pg_catalog;

--
-- TOC entry 3132 (class 2606 OID 135358)
-- Dependencies: 207 207 207
-- Name: commune_nom_depart_key; Type: CONSTRAINT; Schema: ign_bd_topo; Owner: -
--

ALTER TABLE ONLY commune

    ADD CONSTRAINT commune_nom_depart_key UNIQUE (nom, depart);


--
-- TOC entry 3135 (class 2606 OID 135327)
-- Dependencies: 207 207
-- Name: commune_pkey; Type: CONSTRAINT; Schema: ign_bd_topo; Owner: -
--

ALTER TABLE ONLY commune
    ADD CONSTRAINT commune_pkey PRIMARY KEY (code_insee);


--
-- TOC entry 3129 (class 2606 OID 106867)
-- Dependencies: 206 206
-- Name: lieu_dit_pkey; Type: CONSTRAINT; Schema: ign_bd_topo; Owner: -
--

ALTER TABLE ONLY lieu_dit
    ADD CONSTRAINT lieu_dit_pkey PRIMARY KEY (id);


SET search_path = inpn, public, pg_catalog;

--
-- TOC entry 3140 (class 2606 OID 135336)
-- Dependencies: 208 208
-- Name: taxref_pkey; Type: CONSTRAINT; Schema: inpn; Owner: -
--


ALTER TABLE ONLY taxref
    ADD CONSTRAINT taxref_pkey PRIMARY KEY (cd_nom);


--
-- TOC entry 3144 (class 2606 OID 128809)
-- Dependencies: 209 209
-- Name: typo_corine_biotopes_pkey; Type: CONSTRAINT; Schema: inpn; Owner: -
--


ALTER TABLE ONLY typo_corine_biotopes
    ADD CONSTRAINT typo_corine_biotopes_pkey PRIMARY KEY (cd_cb);


SET search_path = md, public, pg_catalog;

--
-- TOC entry 3084 (class 2606 OID 135362)
-- Dependencies: 196 196
-- Name: etude_nom_etude_key; Type: CONSTRAINT; Schema: md; Owner: -
--




ALTER TABLE ONLY etude
    ADD CONSTRAINT etude_nom_etude_key UNIQUE (nom_etude);



--
-- TOC entry 3086 (class 2606 OID 135343)
-- Dependencies: 196 196
-- Name: etude_pkey; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY etude
    ADD CONSTRAINT etude_pkey PRIMARY KEY (id_etude);


--
-- TOC entry 3090 (class 2606 OID 135349)
-- Dependencies: 197 197
-- Name: personne_email_key; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY personne
    ADD CONSTRAINT personne_email_key UNIQUE (email);


--
-- TOC entry 3092 (class 2606 OID 135345)
-- Dependencies: 197 197
-- Name: personne_pkey; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY personne
    ADD CONSTRAINT personne_pkey PRIMARY KEY (id_personne);


--
-- TOC entry 3094 (class 2606 OID 135347)
-- Dependencies: 197 197 197
-- Name: personne_prenom_nom_key; Type: CONSTRAINT; Schema: md; Owner: -
--



ALTER TABLE ONLY personne
    ADD CONSTRAINT personne_prenom_nom_key UNIQUE (prenom, nom);


--
-- TOC entry 3099 (class 2606 OID 135364)
-- Dependencies: 199 199
-- Name: protocole_libelle_key; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY protocole
    ADD CONSTRAINT protocole_libelle_key UNIQUE (libelle);


--
-- TOC entry 3101 (class 2606 OID 135356)
-- Dependencies: 199 199
-- Name: protocole_pkey; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY protocole

    ADD CONSTRAINT protocole_pkey PRIMARY KEY (id_protocole);


--
-- TOC entry 3106 (class 2606 OID 135368)
-- Dependencies: 201 201
-- Name: structure_nom_structure_key; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY structure
    ADD CONSTRAINT structure_nom_structure_key UNIQUE (nom_structure);


--
-- TOC entry 3108 (class 2606 OID 135366)
-- Dependencies: 201 201
-- Name: structure_pkey; Type: CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY structure
    ADD CONSTRAINT structure_pkey PRIMARY KEY (id_structure);


SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 3120 (class 2606 OID 90504)
-- Dependencies: 203 203
-- Name: saisie_observation_pkey; Type: CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_pkey PRIMARY KEY (id_obs);


--
-- TOC entry 3125 (class 2606 OID 135381)
-- Dependencies: 205 205 205 205
-- Name: suivi_saisie_observation_pkey; Type: CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY suivi_saisie_observation
    ADD CONSTRAINT suivi_saisie_observation_pkey PRIMARY KEY (date_operation, utilisateur, id_obs);


SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 3155 (class 2620 OID 90523)
-- Dependencies: 203 1195
-- Name: suivi_saisie_observation; Type: TRIGGER; Schema: saisie; Owner: -
--

CREATE TRIGGER suivi_saisie_observation AFTER INSERT OR DELETE OR UPDATE ON saisie_observation FOR EACH ROW EXECUTE PROCEDURE alimente_suivi_saisie_observation();


SET search_path = inpn, public, pg_catalog;

--
-- TOC entry 3153 (class 2606 OID 135337)
-- Dependencies: 208 208 3139
-- Name: taxref_cd_ref_fkey; Type: FK CONSTRAINT; Schema: inpn; Owner: -
--

ALTER TABLE ONLY taxref
    ADD CONSTRAINT taxref_cd_ref_fkey FOREIGN KEY (cd_ref) REFERENCES taxref(cd_nom);


SET search_path = md, public, pg_catalog;

--
-- TOC entry 3145 (class 2606 OID 135350)
-- Dependencies: 197 197 3091
-- Name: personne_createur_fkey; Type: FK CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY personne
    ADD CONSTRAINT personne_createur_fkey FOREIGN KEY (createur) REFERENCES personne(id_personne);


--
-- TOC entry 3146 (class 2606 OID 135369)
-- Dependencies: 197 3091 201
-- Name: structure_createur_fkey; Type: FK CONSTRAINT; Schema: md; Owner: -
--

ALTER TABLE ONLY structure
    ADD CONSTRAINT structure_createur_fkey FOREIGN KEY (createur) REFERENCES personne(id_personne);


SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 3149 (class 2606 OID 135397)
-- Dependencies: 3134 203 207
-- Name: saisie_observation_code_insee_fkey; Type: FK CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_code_insee_fkey FOREIGN KEY (code_insee) REFERENCES ign_bd_topo.commune(code_insee);


--
-- TOC entry 3147 (class 2606 OID 135382)
-- Dependencies: 203 196 3085
-- Name: saisie_observation_id_etude_fkey; Type: FK CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_id_etude_fkey FOREIGN KEY (id_etude) REFERENCES md.etude(id_etude);


--

-- TOC entry 3150 (class 2606 OID 135402)
-- Dependencies: 3128 203 206
-- Name: saisie_observation_id_lieu_dit_fkey; Type: FK CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_id_lieu_dit_fkey FOREIGN KEY (id_lieu_dit) REFERENCES ign_bd_topo.lieu_dit(id);


--
-- TOC entry 3148 (class 2606 OID 135387)
-- Dependencies: 203 3100 199
-- Name: saisie_observation_id_protocole_fkey; Type: FK CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_id_protocole_fkey FOREIGN KEY (id_protocole) REFERENCES md.protocole(id_protocole);


--
-- TOC entry 3151 (class 2606 OID 135457)
-- Dependencies: 3091 197 203
-- Name: saisie_observation_numerisateur_fkey; Type: FK CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_numerisateur_fkey FOREIGN KEY (numerisateur) REFERENCES md.personne(id_personne);


--
-- TOC entry 3152 (class 2606 OID 135462)
-- Dependencies: 197 203 3091
-- Name: saisie_observation_validateur_fkey; Type: FK CONSTRAINT; Schema: saisie; Owner: -
--

ALTER TABLE ONLY saisie_observation
    ADD CONSTRAINT saisie_observation_validateur_fkey FOREIGN KEY (validateur) REFERENCES md.personne(id_personne);


--
-- TOC entry 3159 (class 0 OID 0)
-- Dependencies: 8
-- Name: ign_bd_topo; Type: ACL; Schema: -; Owner: -
--

GRANT USAGE ON SCHEMA ign_bd_topo TO sicen_gr_consult;


--
-- TOC entry 3161 (class 0 OID 0)
-- Dependencies: 9
-- Name: inpn; Type: ACL; Schema: -; Owner: -
--

GRANT USAGE ON SCHEMA inpn TO sicen_gr_consult;


--
-- TOC entry 3163 (class 0 OID 0)
-- Dependencies: 10
-- Name: md; Type: ACL; Schema: -; Owner: -
--

GRANT USAGE ON SCHEMA md TO sicen_gr_consult;
GRANT USAGE ON SCHEMA md TO sicen_cnx;


--
-- TOC entry 3164 (class 0 OID 0)
-- Dependencies: 11
-- Name: outils; Type: ACL; Schema: -; Owner: -
--

GRANT USAGE ON SCHEMA outils TO sicen_gr_consult;
GRANT USAGE ON SCHEMA outils TO sicen_cnx;


--
-- TOC entry 3166 (class 0 OID 0)
-- Dependencies: 12
-- Name: saisie; Type: ACL; Schema: -; Owner: -
--

GRANT USAGE ON SCHEMA saisie TO sicen_gr_consult;


SET search_path = outils, public, pg_catalog;

--
-- TOC entry 3167 (class 0 OID 0)
-- Dependencies: 1198
-- Name: get_user(); Type: ACL; Schema: outils; Owner: -
--

GRANT EXECUTE ON FUNCTION get_user() TO sicen_gr_amateur;
GRANT EXECUTE ON FUNCTION get_user() TO sicen_cnx;


--
-- TOC entry 3168 (class 0 OID 0)
-- Dependencies: 1199
-- Name: set_user(text); Type: ACL; Schema: outils; Owner: -
--

GRANT EXECUTE ON FUNCTION set_user(myid_user text) TO sicen_gr_amateur;
GRANT EXECUTE ON FUNCTION set_user(myid_user text) TO sicen_cnx;


SET search_path = ign_bd_topo, public, pg_catalog;

--
-- TOC entry 3169 (class 0 OID 0)
-- Dependencies: 207
-- Name: commune; Type: ACL; Schema: ign_bd_topo; Owner: -
--

GRANT SELECT ON TABLE commune TO sicen_gr_consult;


--
-- TOC entry 3170 (class 0 OID 0)
-- Dependencies: 206
-- Name: lieu_dit; Type: ACL; Schema: ign_bd_topo; Owner: -
--

GRANT SELECT ON TABLE lieu_dit TO sicen_gr_consult;


SET search_path = inpn, public, pg_catalog;

--
-- TOC entry 3177 (class 0 OID 0)
-- Dependencies: 208
-- Name: taxref; Type: ACL; Schema: inpn; Owner: -
--

GRANT SELECT ON TABLE taxref TO sicen_gr_consult;


--
-- TOC entry 3181 (class 0 OID 0)
-- Dependencies: 209
-- Name: typo_corine_biotopes; Type: ACL; Schema: inpn; Owner: -
--

GRANT SELECT ON TABLE typo_corine_biotopes TO sicen_gr_consult;


SET search_path = md, public, pg_catalog;

--
-- TOC entry 3182 (class 0 OID 0)
-- Dependencies: 195
-- Name: etude_id_etude_seq; Type: ACL; Schema: md; Owner: -
--

GRANT USAGE ON SEQUENCE etude_id_etude_seq TO sicen_gr_admin;


--
-- TOC entry 3184 (class 0 OID 0)
-- Dependencies: 196
-- Name: etude; Type: ACL; Schema: md; Owner: -
--

GRANT SELECT ON TABLE etude TO sicen_gr_consult;
GRANT INSERT,DELETE,UPDATE ON TABLE etude TO sicen_gr_admin;


--
-- TOC entry 3186 (class 0 OID 0)
-- Dependencies: 197
-- Name: personne; Type: ACL; Schema: md; Owner: -
--

GRANT SELECT ON TABLE personne TO sicen_gr_consult;
GRANT SELECT ON TABLE personne TO sicen_cnx;
GRANT INSERT,UPDATE ON TABLE personne TO sicen_gr_amateur;


--
-- TOC entry 3188 (class 0 OID 0)
-- Dependencies: 198
-- Name: personne_id_personne_seq; Type: ACL; Schema: md; Owner: -
--

GRANT USAGE ON SEQUENCE personne_id_personne_seq TO sicen_gr_amateur;


--
-- TOC entry 3190 (class 0 OID 0)
-- Dependencies: 199
-- Name: protocole; Type: ACL; Schema: md; Owner: -
--

GRANT SELECT ON TABLE protocole TO sicen_gr_consult;
GRANT INSERT,DELETE,UPDATE ON TABLE protocole TO sicen_gr_admin;


--
-- TOC entry 3192 (class 0 OID 0)
-- Dependencies: 200
-- Name: protocole_id_protocole_seq; Type: ACL; Schema: md; Owner: -
--

GRANT USAGE ON SEQUENCE protocole_id_protocole_seq TO sicen_gr_admin;


--
-- TOC entry 3194 (class 0 OID 0)
-- Dependencies: 201
-- Name: structure; Type: ACL; Schema: md; Owner: -
--

GRANT SELECT ON TABLE structure TO sicen_gr_consult;
GRANT INSERT,UPDATE ON TABLE structure TO sicen_gr_amateur;
GRANT SELECT ON TABLE structure TO sicen_cnx;


--
-- TOC entry 3196 (class 0 OID 0)
-- Dependencies: 202
-- Name: structure_id_structure_seq; Type: ACL; Schema: md; Owner: -
--

GRANT USAGE ON SEQUENCE structure_id_structure_seq TO sicen_gr_amateur;



SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 3198 (class 0 OID 0)
-- Dependencies: 203
-- Name: saisie_observation; Type: ACL; Schema: saisie; Owner: -
--

GRANT SELECT ON TABLE saisie_observation TO sicen_gr_consult;
GRANT INSERT,DELETE,UPDATE ON TABLE saisie_observation TO sicen_gr_admin;


--
-- TOC entry 3199 (class 0 OID 0)
-- Dependencies: 203
-- Name: saisie_observation.validateur; Type: ACL; Schema: saisie; Owner: -
--

GRANT UPDATE(validateur) ON TABLE saisie_observation TO sicen_gr_expert;


--
-- TOC entry 3200 (class 0 OID 0)
-- Dependencies: 203
-- Name: saisie_observation.statut_validation; Type: ACL; Schema: saisie; Owner: -
--

GRANT UPDATE(statut_validation) ON TABLE saisie_observation TO sicen_gr_expert;


--
-- TOC entry 3201 (class 0 OID 0)
-- Dependencies: 203
-- Name: saisie_observation.decision_validation; Type: ACL; Schema: saisie; Owner: -
--

GRANT UPDATE(decision_validation) ON TABLE saisie_observation TO sicen_gr_expert;


--
-- TOC entry 3203 (class 0 OID 0)
-- Dependencies: 204
-- Name: saisie_observation_id_obs_seq; Type: ACL; Schema: saisie; Owner: -
--

GRANT USAGE ON SEQUENCE saisie_observation_id_obs_seq TO sicen_gr_amateur;


--
-- TOC entry 3205 (class 0 OID 0)
-- Dependencies: 205
-- Name: suivi_saisie_observation; Type: ACL; Schema: saisie; Owner: -
--

GRANT SELECT,INSERT ON TABLE suivi_saisie_observation TO sicen_gr_amateur;


-- Completed on 2012-12-26 10:29:58

--
-- PostgreSQL database dump complete
--

/* 

ATTENTION : paramtrer le systme de projection avant d'excuter en remplaant les "2154" par le code EPSG de vos rfrentiels cartographiques

Remarque : pensez  rafrachir la base avant de lancer ce script

*/

SELECT public.AddGeometryColumn('ign_bd_topo'::varchar,'commune'::varchar,'geometrie'::varchar,2154,'MULTIPOLYGON'::varchar,2);
SELECT public.AddGeometryColumn('ign_bd_topo'::varchar,'lieu_dit'::varchar,'geometrie'::varchar,2154,'POINT'::varchar,2);
SELECT public.AddGeometryColumn('saisie'::varchar,'saisie_observation'::varchar,'geometrie'::varchar,2154,'GEOMETRY'::varchar,2);
SELECT public.AddGeometryColumn('saisie'::varchar,'suivi_saisie_observation'::varchar,'geometrie'::varchar,2154,'GEOMETRY'::varchar,2);


SET search_path = md, public, pg_catalog;

--
-- TOC entry 1192 (class 1255 OID 90392)
-- Dependencies: 10 1634
-- Name: creation_modification_observateur(); Type: FUNCTION; Schema: md; Owner: -
--

CREATE FUNCTION creation_modification_observateur() RETURNS trigger
    LANGUAGE plpgsql SECURITY DEFINER
    AS '
DECLARE
	var_ancien_code_observateur character varying;
	var_ancien_login character varying;
	var_password character varying;
	var_ancien_role md.enum_role;
	var_nouveau_role md.enum_role;
	myrec RECORD;
 
BEGIN
	IF (TG_OP = ''DELETE'') THEN -- mise  jour d''un utilisateur (mot de passe et mail non nuls et role diffrent de observ
		EXECUTE 
			$req$
				DROP VIEW IF EXISTS saisie.saisie_observation_$req$||(OLD.id_personne)::text||$req$;
			$req$;
	END IF;
	IF (TG_OP = ''INSERT'' OR TG_OP = ''UPDATE'') THEN
		IF ((NEW.role=''amateur'') OR (NEW.role=''expert'') OR (NEW.role=''admin'')) THEN
			EXECUTE 
			$req$
				DROP VIEW IF EXISTS saisie.saisie_observation_$req$||(NEW.id_personne)::text||$req$;
				CREATE OR REPLACE VIEW saisie.saisie_observation_$req$||(NEW.id_personne)::text||$req$ AS
				SELECT * FROM saisie.saisie_observation WHERE saisie_observation.numerisateur = $req$||NEW.id_personne||$req$;
				GRANT SELECT, INSERT, DELETE, UPDATE ON TABLE saisie.saisie_observation_$req$||(NEW.id_personne)::text||$req$ TO obs_occ_pnp_gr_amateur;
			$req$;
		RAISE INFO ''vue cre pour %'', (NEW.id_personne)::text;
 
		RAISE INFO ''Cration des rgles d''''accs  ces vues pour =%'', NEW.email;		
		EXECUTE 
			$req$
				-- rgle lors de l''ajout de donnes  la vue : INSERT
				CREATE OR REPLACE RULE insert_saisie_observation_$req$||(NEW.id_personne)::text||$req$ AS ON INSERT TO saisie.saisie_observation_$req$||(NEW.id_personne)::text||$req$
				DO INSTEAD
				INSERT INTO saisie.saisie_observation(heure_obs, date_obs, date_debut_obs, date_fin_obs, date_textuelle, regne, nom_vern, nom_complet, cd_nom, effectif_min, effectif_max, type_effectif, phenologie, id_waypoint, longitude, latitude, elevation, localisation, observateur, numerisateur, validateur, structure, remarque_obs, geometrie, code_insee, id_lieu_dit, determination, statut_validation, decision_validation, id_etude, id_protocole, effectif_textuel, diffusable, "precision", effectif, url_photo, commentaire_photo)
				VALUES (NEW.heure_obs, NEW.date_obs, NEW.date_debut_obs, NEW.date_fin_obs, NEW.date_textuelle, NEW.regne, NEW.nom_vern, NEW.nom_complet, NEW.cd_nom, NEW.effectif_min, NEW.effectif_max, NEW.type_effectif, NEW.phenologie, NEW.id_waypoint, NEW.longitude, NEW.latitude, NEW.elevation, NEW.localisation, NEW.observateur, NEW.numerisateur, NEW.validateur, NEW.structure, NEW.remarque_obs, NEW.geometrie, NEW.code_insee, NEW.id_lieu_dit, NEW.determination, NEW.statut_validation, NEW.decision_validation, NEW.id_etude, NEW.id_protocole, NEW.effectif_textuel, NEW.diffusable, NEW."precision", NEW.effectif, NEW.url_photo, NEW.commentaire_photo);
 
				-- rgle lors de la mise  jour de donnes de la vue : UPDATE
				CREATE OR REPLACE RULE update_saisie_observation_$req$||(NEW.id_personne)::text||$req$ AS ON UPDATE TO saisie.saisie_observation_$req$||(NEW.id_personne)::text||$req$
				DO INSTEAD
				UPDATE saisie.saisie_observation
				SET heure_obs = NEW.heure_obs, date_obs = NEW.date_obs, date_debut_obs = NEW.date_debut_obs, date_fin_obs = NEW.date_fin_obs, date_textuelle = NEW.date_textuelle, regne = NEW.regne, nom_vern = NEW.nom_vern, nom_complet = NEW.nom_complet, cd_nom = NEW.cd_nom, effectif_min = NEW.effectif_min, effectif_max = NEW.effectif_max, type_effectif = NEW.type_effectif, phenologie = NEW.phenologie, id_waypoint = NEW.id_waypoint, longitude = NEW.longitude, latitude = NEW.latitude, elevation = NEW.elevation, localisation = NEW.localisation, observateur = NEW.observateur, numerisateur = NEW.numerisateur, validateur = NEW.validateur, structure = NEW.structure, remarque_obs = NEW.remarque_obs, geometrie = NEW.geometrie, code_insee = NEW.code_insee, id_lieu_dit = NEW.id_lieu_dit, determination = NEW.determination, statut_validation = NEW.statut_validation, decision_validation = NEW.decision_validation, id_etude = NEW.id_etude, id_protocole = NEW.id_protocole, effectif_textuel = NEW.effectif_textuel, diffusable = NEW.diffusable, "precision" = NEW."precision", effectif = NEW.effectif, url_photo = NEW.url_photo, commentaire_photo = NEW.commentaire_photo
				WHERE id_obs = OLD.id_obs;
 
				-- rgle lors de la suppression d''une donnes de la vue : DELETE
				CREATE RULE delete_saisie_observation_$req$||(NEW.id_personne)::text||$req$ AS ON DELETE TO saisie.saisie_observation_$req$||(NEW.id_personne)::text||$req$
				DO INSTEAD
				DELETE FROM saisie.saisie_observation
				WHERE id_obs = OLD.id_obs;
			$req$;

		END IF;
	END IF;
	RETURN NULL;
END;
';


SET search_path = ign_bd_topo, public, pg_catalog;

--
-- TOC entry 3130 (class 1259 OID 135329)
-- Dependencies: 207 2509
-- Name: commune_geometrie_idx; Type: INDEX; Schema: ign_bd_topo; Owner: -
--

CREATE INDEX commune_geometrie_idx ON commune USING gist (geometrie);


--
-- TOC entry 3133 (class 1259 OID 135314)
-- Dependencies: 207
-- Name: commune_nom_idx; Type: INDEX; Schema: ign_bd_topo; Owner: -
--

CREATE INDEX commune_nom_idx ON commune USING btree (nom);


--
-- TOC entry 3126 (class 1259 OID 106868)
-- Dependencies: 206 2509
-- Name: lieu_dit_geometrie_idx; Type: INDEX; Schema: ign_bd_topo; Owner: -
--

CREATE INDEX lieu_dit_geometrie_idx ON lieu_dit USING gist (geometrie);


--
-- TOC entry 3127 (class 1259 OID 135315)
-- Dependencies: 206
-- Name: lieu_dit_nom_idx; Type: INDEX; Schema: ign_bd_topo; Owner: -
--

CREATE INDEX lieu_dit_nom_idx ON lieu_dit USING btree (nom);


SET search_path = inpn, public, pg_catalog;

--
-- TOC entry 3136 (class 1259 OID 135325)
-- Dependencies: 208
-- Name: taxref_cd_ref_idx; Type: INDEX; Schema: inpn; Owner: -
--

CREATE INDEX taxref_cd_ref_idx ON taxref USING btree (cd_ref);


--
-- TOC entry 3137 (class 1259 OID 135324)
-- Dependencies: 208
-- Name: taxref_nom_complet_idx; Type: INDEX; Schema: inpn; Owner: -
--

CREATE INDEX taxref_nom_complet_idx ON taxref USING btree (nom_complet);


--
-- TOC entry 3138 (class 1259 OID 135316)
-- Dependencies: 208
-- Name: taxref_nom_vern_idx; Type: INDEX; Schema: inpn; Owner: -
--

CREATE INDEX taxref_nom_vern_idx ON taxref USING btree (nom_vern);


--
-- TOC entry 3141 (class 1259 OID 135317)
-- Dependencies: 208
-- Name: taxref_regne_idx; Type: INDEX; Schema: inpn; Owner: -
--

CREATE INDEX taxref_regne_idx ON taxref USING btree (regne);


-- Index: inpn.taxref_lb_nom_idx

-- DROP INDEX inpn.taxref_lb_nom_idx;

CREATE INDEX taxref_lb_nom_idx
  ON inpn.taxref
  USING btree
  (lb_nom );
  
  
--
-- TOC entry 3142 (class 1259 OID 128810)
-- Dependencies: 209
-- Name: typo_corine_biotopes_lb_cb97_fr_idx; Type: INDEX; Schema: inpn; Owner: -
--

CREATE INDEX typo_corine_biotopes_lb_cb97_fr_idx ON typo_corine_biotopes USING btree (lb_cb97_fr);


SET search_path = md, public, pg_catalog;

--
-- TOC entry 3082 (class 1259 OID 135318)
-- Dependencies: 196
-- Name: etude_nom_etude_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX etude_nom_etude_idx ON etude USING btree (nom_etude);


--
-- TOC entry 3087 (class 1259 OID 135320)
-- Dependencies: 197
-- Name: personne_createur_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX personne_createur_idx ON personne USING btree (createur);


--
-- TOC entry 3088 (class 1259 OID 135319)
-- Dependencies: 197
-- Name: personne_email_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX personne_email_idx ON personne USING btree (email);


--
-- TOC entry 3095 (class 1259 OID 135321)
-- Dependencies: 197
-- Name: personne_role_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX personne_role_idx ON personne USING btree (role);


--
-- TOC entry 3096 (class 1259 OID 135322)
-- Dependencies: 197
-- Name: personne_specialite_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX personne_specialite_idx ON personne USING btree (specialite);


--
-- TOC entry 3097 (class 1259 OID 135323)
-- Dependencies: 199
-- Name: protocole_libelle_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX protocole_libelle_idx ON protocole USING btree (libelle);


--
-- TOC entry 3102 (class 1259 OID 135375)
-- Dependencies: 201
-- Name: structure_createur_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX structure_createur_idx ON structure USING btree (createur);


--
-- TOC entry 3103 (class 1259 OID 135376)
-- Dependencies: 201
-- Name: structure_diffusable_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX structure_diffusable_idx ON structure USING btree (diffusable);


--
-- TOC entry 3104 (class 1259 OID 135374)
-- Dependencies: 201
-- Name: structure_nom_structure_idx; Type: INDEX; Schema: md; Owner: -
--

CREATE INDEX structure_nom_structure_idx ON structure USING btree (nom_structure);


SET search_path = saisie, public, pg_catalog;

--
-- TOC entry 3109 (class 1259 OID 135313)
-- Dependencies: 203
-- Name: saisie_observation_cd_nom_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_cd_nom_idx ON saisie_observation USING btree (cd_nom);


--
-- TOC entry 3110 (class 1259 OID 135470)
-- Dependencies: 203
-- Name: saisie_observation_code_insee_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_code_insee_idx ON saisie_observation USING btree (code_insee);


--
-- TOC entry 3111 (class 1259 OID 135472)
-- Dependencies: 203
-- Name: saisie_observation_diffusable_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_diffusable_idx ON saisie_observation USING btree (diffusable);


--
-- TOC entry 3112 (class 1259 OID 135415)
-- Dependencies: 2509 203
-- Name: saisie_observation_geometrie_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_geometrie_idx ON saisie_observation USING gist (geometrie);


--
-- TOC entry 3113 (class 1259 OID 135474)
-- Dependencies: 203
-- Name: saisie_observation_id_etude_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_id_etude_idx ON saisie_observation USING btree (id_etude);


--
-- TOC entry 3114 (class 1259 OID 135471)
-- Dependencies: 203
-- Name: saisie_observation_id_lieu_dit_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_id_lieu_dit_idx ON saisie_observation USING btree (id_lieu_dit);


--
-- TOC entry 3115 (class 1259 OID 135475)
-- Dependencies: 203
-- Name: saisie_observation_id_protocole_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_id_protocole_idx ON saisie_observation USING btree (id_protocole);


--
-- TOC entry 3116 (class 1259 OID 135476)
-- Dependencies: 203
-- Name: saisie_observation_nom_complet_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_nom_complet_idx ON saisie_observation USING btree (nom_complet);


--
-- TOC entry 3117 (class 1259 OID 135413)
-- Dependencies: 203
-- Name: saisie_observation_nom_vern_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_nom_vern_idx ON saisie_observation USING btree (nom_vern);


--
-- TOC entry 3118 (class 1259 OID 135418)
-- Dependencies: 203
-- Name: saisie_observation_numerisateur_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_numerisateur_idx ON saisie_observation USING btree (numerisateur);


--
-- TOC entry 3121 (class 1259 OID 135412)
-- Dependencies: 203
-- Name: saisie_observation_regne_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_regne_idx ON saisie_observation USING btree (regne);


--
-- TOC entry 3122 (class 1259 OID 135473)
-- Dependencies: 203
-- Name: saisie_observation_statut_validation_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_statut_validation_idx ON saisie_observation USING btree (statut_validation);


--
-- TOC entry 3123 (class 1259 OID 135469)
-- Dependencies: 203
-- Name: saisie_observation_validateur_idx; Type: INDEX; Schema: saisie; Owner: -
--

CREATE INDEX saisie_observation_validateur_idx ON saisie_observation USING btree (validateur);


SET search_path = md, public, pg_catalog;

--
-- TOC entry 3154 (class 2620 OID 109526)
-- Dependencies: 197 1192
-- Name: md_creation_observateur; Type: TRIGGER; Schema: md; Owner: -
--

CREATE TRIGGER md_creation_observateur AFTER INSERT OR DELETE OR UPDATE ON personne FOR EACH ROW EXECUTE PROCEDURE creation_modification_observateur();
