<?php
    session_start();
    set_include_path('../../../Librairies/PEAR/');
    require_once '../../../Librairies/PEAR/Crypt/RSA.php';
    require_once '../Configuration/PostGreSQL.php';
    require_once '../../../Outils/Fct.php';
   
    // Génération de nouvelles clés RSA classiques
    $nbBits = 128;
    $key_pair = new Crypt_RSA_KeyPair($nbBits, 'BCMath');
    $public_key = $key_pair->getPublicKey();
    $private_key = $key_pair->getPrivateKey();
    // Remplacement en session par la clé privée classique
    $_SESSION[APPLI]['Securite']['private_module'] = $private_key->getModulus();
    $_SESSION[APPLI]['Securite']['private_exp'] = $private_key->getExponent();
    // Cryptage RSA classique des variables de session utilisées dans le constructeur de "CnxPgObsOcc" appelé par "Personne::authentifie"
    $rsa_obj = new Crypt_RSA(null, 'BCMath');
    $_SESSION[APPLI]['Connexion']['USER'] = $rsa_obj->encrypt(USER, $public_key);
    $_SESSION[APPLI]['Connexion']['PASSWORD'] = $rsa_obj->encrypt(PASSWORD, $public_key);
?>
<html>
    <head>
        <title>Demande</title>
        <!-- Définition du jeu de caractères -->
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <!-- Bibliothèque Ext en français (version de production) -->
        <script type="text/javascript" src="../../../Librairies/Ext/adapter/ext/ext-base.js"></script>
        <script type="text/javascript" src="../../../Librairies/Ext/ext-all.js"></script>
        <script type="text/javascript" src="../../../Librairies/Ext/src/locale/ext-lang-fr.js"></script>
        <!-- Complément de Ext -->
        <script type="text/javascript" src="../../../Librairies/Ext/examples/ux/ux-all.js"></script>
        <!-- Feuilles de style -->
        <link type="text/css" rel="stylesheet" href="../../../Librairies/Ext/resources/css/ext-all.css" />
        <link type="text/css" rel="stylesheet" href="../../../Librairies/Ext/examples/ux/css/ux-all.css" />
        <link type="text/css" rel="stylesheet" href="../../../Librairies/Ext/examples/ux/statusbar/css/statusbar.css" />
        <link type="text/css" rel="stylesheet" href="../../../Ergonomie/Formulaires/frmFds.css" />
        <link type="text/css" rel="stylesheet" href="../../../Ergonomie/Grilles/gFds.css" />
        <!-- Personnalisation de l'application -->
        <script type="text/javascript" src="../Configuration/Application.js"></script>
        <!-- Outils -->
        <script type="text/javascript" src="../../../Outils/Global.js"></script>
        <!-- Formulaire -->
        <script type="text/javascript" src="../Controleurs/Formulaires/frmDemande.js"></script>
    </head>
    <body>
    </body>
</html>
