<?php
    session_start();
    set_include_path('../../../Librairies/PEAR/');
    require_once '../../../Librairies/PEAR/Crypt/RSA.php';
    require_once '../../../Adaptations/CryptRSA/class/myKey.php';
    require_once '../../../Adaptations/CryptRSA/class/myKeyPair.php';
    require_once '../../../Adaptations/CryptRSA/class/myRSA.php';
    require_once '../Configuration/PostGreSQL.php';

    // Génération des clés RSA personnalisées
    $nbBits = 128;
    $key_pair_perso = new Crypt_RSA_myKeyPair($nbBits, 'BCMath');
    $public_key_perso = $key_pair_perso->getPublicKey();
    $private_key_perso = $key_pair_perso->getPrivateKey();
    unset($key_pair_perso);
    // Mise en session de la clé privée personnalisée
    $_SESSION[APPLI]['Securite']['private_module_perso'] = $private_key_perso->getModulus();
    $_SESSION[APPLI]['Securite']['private_exp_perso'] = $private_key_perso->getExponent();

    // Regénération de nouvelles clés RSA classiques
    $key_pair = new Crypt_RSA_KeyPair($nbBits, 'BCMath');
    $public_key = $key_pair->getPublicKey();
    $private_key = $key_pair->getPrivateKey();
    unset($key_pair);
    // Remplacement en session par la clé privée classique
    $_SESSION[APPLI]['Securite']['private_module'] = $private_key->getModulus();
    $_SESSION[APPLI]['Securite']['private_exp'] = $private_key->getExponent();
    // Cryptage RSA classique des variables de session pour initialiser comboStructure
    $rsa_obj = new Crypt_RSA(null, 'BCMath');
    $_SESSION[APPLI]['Connexion']['USER'] = $rsa_obj->encrypt(USER, $public_key);
    $_SESSION[APPLI]['Connexion']['PASSWORD'] = $rsa_obj->encrypt(PASSWORD, $public_key);
    unset($rsa_obj);
?>
<html>
    <head>
        <script type='text/javascript' src='../../../Adaptations/CryptRSA/js/BigInt.js'></script>
        <script type='text/javascript' src='../../../Adaptations/CryptRSA/js/BigIntMath.js'></script>
        <script type='text/javascript' src='../../../Adaptations/CryptRSA/js/RSA.js'></script>
        <script type='text/javascript'>
            // Passage de la clé publique personnalisée au js
            var public_exponent = '<?php echo $public_key_perso->getIntExponent(); ?>';
            var public_modulus = '<?php echo $public_key_perso->getIntModulus(); ?>'
            var nb_bits = <?php echo $nbBits; ?>;
            setMaxDigits(154);
            var public_key = new RSAPublicKey(public_exponent, public_modulus, nb_bits);
        </script>
        <title>Authentification</title>
        <!-- Définition du jeu de caractères -->
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <!-- Bibliothèque Ext en français (version de production) -->
        <script type="text/javascript" src="../../../Librairies/Ext/adapter/ext/ext-base.js"></script>
        <script type="text/javascript" src="../../../Librairies/Ext/ext-all.js"></script>
        <script type="text/javascript" src="../../../Librairies/Ext/src/locale/ext-lang-fr.js"></script>
        <!-- Complément de Ext -->
        <script type="text/javascript" src="../../../Librairies/Ext/examples/ux/ux-all.js"></script>
        <!-- Feuilles de style -->
        <link type="text/css" rel="stylesheet" href="../../../Librairies/Ext/resources/css/ext-all.css" />
        <link type="text/css" rel="stylesheet" href="../../../Librairies/Ext/examples/ux/css/ux-all.css" />
        <link type="text/css" rel="stylesheet" href="../../../Librairies/Ext/examples/ux/statusbar/css/statusbar.css" />
        <link type="text/css" rel="stylesheet" href="../../../Ergonomie/Formulaires/frmFds.css" />
        <!-- Outils -->
        <script type="text/javascript" src="../../../Outils/Global.js"></script>
        <!-- Personnalisation de l'application -->
        <script type="text/javascript" src="../Configuration/Application.js"></script>
        <!-- Formulaire -->
        <script type="text/javascript" src="../Controleurs/Formulaires/frmAuthent.js"></script>
    </head>
    <body>
    </body>
</html>
